Attribute VB_Name = "DRVLNXVB"
' DriverLINX/VB(tm) Custom Control Constants
' (C) Copyright 1994-99 Scientific Software Tools, Inc.
' All Rights Reserved.

' DriverLINX/VB: Defined Constants
Global Const DL_True = 1
Global Const DL_False = 0
                               
' Request: Subsystem Types
Global Const DL_DEVICE = 0
Global Const DL_AI = 1
Global Const DL_AO = 2
Global Const DL_DI = 3
Global Const DL_DO = 4
Global Const DL_CT = 5

' Request: Mode Types
Global Const DL_OTHER = 0
Global Const DL_POLLED = 1
Global Const DL_DMA = 2
Global Const DL_INTERRUPT = 3

' Request: Operation Types
Global Const DL_START = 0
Global Const DL_STOP = 1
Global Const DL_SCHEDULE = 2
Global Const DL_STATUS = 3
Global Const DL_INITIALIZE = 4
Global Const DL_CONFIGURE = 5
Global Const DL_CALIBRATE = 6
Global Const DL_CAPABILITIES = 7
Global Const DL_REQUEST = 8
Global Const DL_RELEASE = 9
Global Const DL_MESSAGEBOX = 10
Global Const DL_TEST = 11
Global Const DL_CONVERT = 12

' Result: Status Types
Global Const DL_IOVALUE = 0
Global Const DL_TIMERSTATUS = 1
Global Const DL_IOSTATUS = 2
Global Const DL_CAPSTATUS = 3
Global Const DL_CALCONST = 4

' Result: Task Status Types
Global Const DL_scheduled = 0
Global Const DL_armed = 1
Global Const DL_active = 2
Global Const DL_inactive = 3
Global Const DL_done = 4

' Result: Type of data error for lostData field of IO_STATUS
Global Const DL_DataLost = 1           ' I/O data lost
Global Const DL_queueOverflow = 2      ' app message queue overflow
Global Const DL_isrOverrun = 4         ' re-entered busy ISR

' Event: Types
Global Const DL_NULLEVENT = 0
Global Const DL_COMMAND = 1
Global Const DL_INTEVENT = 2
Global Const DL_FLAGEVENT = 3
Global Const DL_TIMEEVENT = 4
Global Const DL_TCEVENT = 5
Global Const DL_AIEVENT = 6
Global Const DL_DIEVENT = 7
Global Const DL_RATEEVENT = 8
Global Const DL_CTSETUP = 9
Global Const DL_DIOSETUP = 10
Global Const DL_DATACONVERT = 11
Global Const DL_TIMEBASE = 12
Global Const DL_COUNTEVENT = 13
Global Const DL_GROUPEVENT = 14

' Event: Analog Slope flags
Global Const AnaTrgNegInside = 0       ' negative slope or inside limits
Global Const AnaTrgPosOutside = 1      ' positive slope or outside limits
Global Const AnaTrgDUALCROSSING = 2     ' dual threshold crossing flag
Global Const AnaTrgACCOUPLING = 4      ' AC trigger coupling

' Event: Digital Match flags
Global Const DL_Equals = 1
Global Const DL_NotEquals = 0

' Event: Time Channel IDs
Global Const DL_PCSYSTEMTIMER = &HFF   ' PC 8254 system timer
Global Const DL_ATRTC = &HFE           ' AT CMOS MC146818 real time clock
Global Const DL_DEFAULTTIMER = &HFD    ' default timer channel for subsystem

' Event: Time Event Types
Global Const DL_TimeOfDay = 1
Global Const DL_TimeDelay = 0

' Event: Rate Generator Types
Global Const DL_RATEGEN = 0
Global Const DL_SQWAVE = 1
Global Const DL_VDCGEN = 2
Global Const DL_BURSTGEN = 3
Global Const DL_DIVIDER = 4
Global Const DL_FREQ = 5
Global Const DL_INTERVAL = 6
Global Const DL_COUNT = 7
Global Const DL_PULSEWD = 8
Global Const DL_SPLITCLOCK = 9
Global Const DL_FSKGEN = 10
Global Const DL_ONESHOT = 11
Global Const DL_RETRIGONESHOT = 12
Global Const DL_PULSEGEN = 13
Global Const DL_RETRIGPULSEGEN = 14
Global Const DL_FREQRATIO = 15
Global Const DL_FREQ32 = 16
Global Const DL_COUNT32 = 17
Global Const DL_COUNT64 = 18
Global Const DL_RETRIGCOUNT = 19
Global Const DL_RETRIGRATEGEN = 20
Global Const DL_RETRIGSQWAVE = 21

' Event: Rate Clock Types
Global Const DL_INTERNAL1 = 0             ' Master internal clock
Global Const DL_INTERNAL2 = 1
Global Const DL_INTERNAL3 = 2
Global Const DL_INTERNAL4 = 3
Global Const DL_INTERNAL5 = 4
Global Const DL_GATE1 = 5
Global Const DL_GATE2 = 6
Global Const DL_GATE3 = 7
Global Const DL_GATE4 = 8
Global Const DL_GATE5 = 9
Global Const DL_SOURCE1 = 10
Global Const DL_SOURCE2 = 11
Global Const DL_SOURCE3 = 12
Global Const DL_SOURCE4 = 13
Global Const DL_SOURCE5 = 14
Global Const DL_EXTERNAL = 15             ' Default external clock
Global Const DL_EXTERNALPE = 16
Global Const DL_EXTERNALNE = 17
Global Const DL_TCNm1 = 18
Global Const DL_mINTERNAL1 = 19
Global Const DL_mINTERNAL2 = 20
Global Const DL_mINTERNAL3 = 21
Global Const DL_mINTERNAL4 = 22
Global Const DL_mINTERNAL5 = 23
Global Const DL_mGATE1 = 24 
Global Const DL_mGATE2 = 25 
Global Const DL_mGATE3 = 26 
Global Const DL_mGATE4 = 27 
Global Const DL_mGATE5 = 28
Global Const DL_mSOURCE1 = 29 
Global Const DL_mSOURCE2 = 30 
Global Const DL_mSOURCE3 = 31 
Global Const DL_mSOURCE4 = 32 
Global Const DL_mSOURCE5 = 33
Global Const DL_mTCNm1 = 34

Global Const DL_DI_EXTTRG = -1            ' Specifies a dedicated hdw ext trig line if any.
Global Const DL_DI_EXTCLK = -2            ' Specifies a dedicated hdw ext clock line if any.
                       
' Event: Rate Gate Status Types
Global Const DL_ENABLED = 0
Global Const DL_DISABLED = 1
Global Const DL_NOCONNECT = 2
Global Const DL_LOLEVELGATEN = 3
Global Const DL_LOEDGEGATEN = 4
Global Const DL_HILEVELGATEN = 5
Global Const DL_HILEVELGATENp1 = 6
Global Const DL_HILEVELGATENm1 = 7
Global Const DL_HITCNm1 = 8
Global Const DL_HIEDGEGATEN = 9

' Event: Rate Output Types
Global Const DL_OUTPUTDEFAULT = 0
Global Const DL_OUTPUTLOTOGGLED = 1
Global Const DL_OUTPUTLOACTIVE = 2
Global Const DL_OUTPUTLOZ = 3
Global Const DL_OUTPUTTOGGLED = 4
Global Const DL_OUTPUTHITOGGLED = 5
Global Const DL_OUTPUTHIACTIVE = 6
Global Const DL_OUTPUTHIZ = 7

' Flag Event: Match Flags
Global Const DL_MatchAllBits = 1
Global Const DL_MatchAnyBit = 0

' Setup Event: DIO Mode Types
Global Const DL_DIO_BASIC = &H0&                ' simple I/O
Global Const DL_DIO_STROBED = &H10000000        ' I/O with handshaking
Global Const DL_DIO_BIDIRECTIONAL = &H20000000  ' bidirectional I/O

' Setup Event: CT Gate Mode Types
Global Const DL_HILEVEL = 0
Global Const DL_LOLEVEL = 1
Global Const DL_UPEDGE = 2
Global Const DL_DOWNEDGE = 3

' Event: Rate Counter Output Types
Global Const DL_ACTIVEHI = 0
Global Const DL_ACTIVELO = 1
Global Const DL_HIZ = 2

' Select: Channels Zero Reference Types
Global Const DL_DISABLE_ZEROREF = -1
Global Const DL_HARDWARE_ZEROREF = -2

' Select: Buffers Number Format Types
Global Const DL_tNATIVE = 0
Global Const DL_tBYTE = 1
Global Const DL_tINTEGER = 2
Global Const DL_tLONG = 3
Global Const DL_tSINGLE = 4
Global Const DL_tDOUBLE = 5

' Select: Buffers Notify flags
Global Const DL_NOEVENTS = &H0                  ' no buffer filled events
Global Const DL_NOTIFY = &H1                    ' send buffer filled events
Global Const DL_HANDSHAKE = &H2                 ' require buffer acknowlegement
Global Const DL_NOTIFY_START = &H4              ' send start event events
Global Const DL_NOTIFY_STOP = &H8               ' send stop event  events

' Select: Critical Section Flags
Global Const CS_NONE = &H0                    ' no critical section
Global Const CS_BLOCK_TIMER = &H1             ' block timer tics
Global Const CS_BLOCK_KEYBOARD = &H2          ' block keyboard input
Global Const CS_BLOCK_MOUSE = &H4             ' block mouse input
Global Const CS_BLOCK_INPUT = &H6             ' block keyboard and mouse input
Global Const CS_BLOCK_NEWFOCUS = &H10         ' block change of Window focus
Global Const CS_BLOCK_TIMESLICING = &H20      ' block pre-emptive multitasking
Global Const CS_BLOCK_ALL = &HFFFF            ' block all asynchronous events

Global Const NO_SERVICESTART = &H8000 ' block service start event
Global Const NO_SERVICEDONE = &H4000 ' block service done event

'/* For boards support programmable single-ended vs. differential inputs */
Public Const CHAN_SEDIFF_SHIFT = 13
Public Const CHAN_SEDIFF_MASK = (3 * 2 ^ CHAN_SEDIFF_SHIFT)
Public Const CHAN_SEDIFF_DEFAULT = (0 * 2 ^ CHAN_SEDIFF_SHIFT) ' /* use static config */
Public Const CHAN_SEDIFF_SE = (2 * 2 ^ CHAN_SEDIFF_SHIFT)   ' /* single-ended input */
Public Const CHAN_SEDIFF_DIFF = (3 * 2 ^ CHAN_SEDIFF_SHIFT) ' /* differential input */

' Support Function: VBArrayBufferXfer - "toBuf" direction flags
Global Const DL_VBArrayToBuffer = 1
Global Const DL_BufferToVBArray = 0

' Support Functions
Function DLBytes2Samples&(hctl As Control, ByVal chan%, ByVal bytes&)
DLBytes2Samples = hctl.DLBytes2Samples(chan, bytes)
End Function

Function DLCode2Gain!(hctl As Control, ByVal code%)
DLCode2Gain = hctl.DLCode2Gain(code)
End Function


Function DLCode2Volts!(hctl As Control, ByVal code&)
DLCode2Volts = hctl.DLCode2Volts(code)
End Function

Function DLGain2Code%(hctl As Control, ByVal gain!)
DLGain2Code = hctl.DLGain2Code(gain)
End Function


Function DLGain2Volts!(hctl As Control, ByVal gainCode%, ByVal maxVolts%)
DLGain2Volts = hctl.DLGain2Volts(gainCode, maxVolts)
End Function

Function DLInp(hctl As Control, ByVal portAddr%) As Byte
    hctl.DLInp (portAddr)
End Function

Function DLMinSRPeriod%(hctl As Control)
DLMinSRPeriod = hctl.DLMinSRPeriod()
End Function

Function DLSamples2Bytes&(hctl As Control, ByVal chan%, ByVal samples&)
DLSamples2Bytes = hctl.DLSamples2Bytes(chan, samples&)
End Function

Function DLSecs2Tics&(hctl As Control, ByVal chan%, ByVal secs!)
DLSecs2Tics = hctl.DLSecs2Tics(chan, secs)
End Function

Function DLTics2Secs!(hctl As Control, ByVal chan%, ByVal tics&)
DLTics2Secs = hctl.DLTics2Secs(chan, tics)
End Function

Function DLVolts2Code&(hctl As Control, ByVal volts!)
DLVolts2Code = hctl.DLVolts2Code(volts)
End Function

Public Function VBArrayBufferXfer(hctl As Control, ByVal bufIndex As Integer, arrayData As Variant, ByVal toBuf As Integer)
    VBArrayBufferXfer = hctl.VBArrayBufferXfer(bufIndex, arrayData, toBuf)
End Function

Public Function VBArrayBufferConvert&(hctl As Control, ByVal bufIndex%, ByVal bufOfs&, ByVal nPts&, arrayData As Variant, ByVal dataType%, ByVal scaling!, ByVal offset!)
        VBArrayBufferConvert = hctl.VBArrayBufferConvert(bufIndex, bufOfs, nPts, arrayData, dataType, scaling, offset)
End Function

Public Function VBTimebase&(hctl As Control, period!, nCycles%, nChan%, timeArray As Variant)
        VBTimebase = hctl.VBTimebase(period, nCycles, nChan, timeArray)
End Function



